/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Renderers {
    private LinkedList<FileContentRenderer> rendererTypes = new LinkedList();

    public void add(FileContentRenderer renderer) {
        this.rendererTypes.add(renderer);
    }

    public List<FileContentRenderer> getRendererTypes() {
        return Collections.unmodifiableList(this.rendererTypes);
    }

    private FileContentRenderer forTargetPath(Path path) {
        for (FileContentRenderer rendererType : this.rendererTypes) {
            if (!rendererType.canRender(path)) continue;
            return rendererType;
        }
        return null;
    }

    public List<Path> getVirtualPathsFor(Path path) {
        ArrayList<Path> vpaths = new ArrayList<Path>();
        for (FileContentRenderer rendererType : this.rendererTypes) {
            List<Path> virtualPathsFor = rendererType.getVirtualPathsFor(path);
            vpaths.addAll(virtualPathsFor);
        }
        return vpaths;
    }

    public String toString() {
        return this.rendererTypes.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
    }

    public VirtualFile getVirtualFile(Path p) {
        FileContentRenderer renderer = this.forTargetPath(p);
        if (renderer != null) {
            VirtualFile vf = renderer.getVirtualFile(p);
            return vf;
        }
        return null;
    }
}

