/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.fs;

import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.Renderers;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderFSProvider;
import io.virtdata.docsys.metafs.fs.renderfs.fs.VirtualFileCache;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualDirectoryStream;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFile;
import io.virtdata.docsys.metafs.fs.virtual.VirtFS;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Set;

public class RenderFS
extends VirtFS {
    private final RenderFSProvider provider = RenderFSProvider.get();
    Renderers renderers = new Renderers();
    private VirtualFileCache cache = new VirtualFileCache();

    public RenderFS(FileSystem layer, String name) {
        super(layer.getPath(layer.getSeparator(), new String[0]), name);
    }

    public RenderFS(Path wrapped, String name) {
        super(wrapped, name);
    }

    public RenderFS(URI baseUri, String name) {
        this(Path.of(baseUri), name);
    }

    public Renderers getRenderers() {
        return this.renderers;
    }

    public void addRenderers(FileContentRenderer ... rendererType) {
        for (FileContentRenderer renderer : rendererType) {
            this.renderers.add(renderer);
        }
    }

    @Override
    public RenderFSProvider provider() {
        return this.provider;
    }

    public DirectoryStream<Path> newDirectoryStream(DirectoryStream<Path> paths) {
        return new VirtualDirectoryStream(paths, this.renderers);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        MetaPath metaPath = this.assertMetaPath(path);
        Path syspath = (Path)this.metaToSysFunc.apply(metaPath);
        try {
            SeekableByteChannel channel = super.newByteChannel(path, options, attrs);
            return channel;
        }
        catch (Exception e) {
            VirtualFile vf = this.cache.computeIfAbsent(path, this.renderers::getVirtualFile);
            if (vf != null) {
                return vf.getSeekableByteChannel();
            }
            throw e;
        }
    }

    public BasicFileAttributes readAttributes(Path path, Class type, LinkOption ... options) throws IOException {
        try {
            return super.readAttributes(path, type, options);
        }
        catch (Exception e1) {
            VirtualFile vf = this.cache.computeIfAbsent(path, this.renderers::getVirtualFile);
            if (vf != null) {
                return vf.readAttributes(path, type, options);
            }
            throw e1;
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption[] options) throws IOException {
        try {
            return super.readAttributes(path, attributes, options);
        }
        catch (Exception e1) {
            VirtualFile vf = this.cache.computeIfAbsent(path, this.renderers::getVirtualFile);
            if (vf != null) {
                return vf.readAttributes(path, attributes, options);
            }
            throw e1;
        }
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        try {
            super.checkAccess(path, modes);
        }
        catch (Exception e1) {
            VirtualFile vf = this.cache.computeIfAbsent(path, this.renderers::getVirtualFile);
            if (vf != null) {
                vf.checkAccess(path, modes);
            }
            throw e1;
        }
    }

    @Override
    public FileAttributeView getFileAttributeView(Path path, Class type, LinkOption[] options) {
        try {
            super.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return super.getFileAttributeView(path, type, options);
        }
        catch (IOException e1) {
            VirtualFile vf = this.cache.computeIfAbsent(path, this.renderers::getVirtualFile);
            if (vf != null) {
                return vf.getFileAttributeView(path, type, options);
            }
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return "RenderFS(" + this.getName() + "): root=" + super.getOuterMount().toString() + " renderers=" + this.renderers;
    }

    private VirtFS assertThisFs(MetaPath metaPath) {
        if (metaPath.getFileSystem() != this) {
            throw new InvalidParameterException("This path is not a member of this filesystem.");
        }
        return (RenderFS)metaPath.getFileSystem();
    }

    private MetaPath assertMetaPath(Path path) {
        if (!(path instanceof MetaPath)) {
            throw new InvalidParameterException("This path must be an instance of MetaPath to work with " + this);
        }
        return (MetaPath)path;
    }
}

