/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio;

import io.virtdata.docsys.metafs.core.AugmentingIterator;
import io.virtdata.docsys.metafs.fs.renderfs.api.Renderers;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;

public class VirtualDirectoryStream
implements DirectoryStream<Path> {
    private final DirectoryStream<Path> wrappedStream;
    private final NameMappingFunc func;

    public VirtualDirectoryStream(DirectoryStream<Path> wrappedStream, Renderers renderers) {
        this.wrappedStream = wrappedStream;
        this.func = new NameMappingFunc(renderers);
    }

    @Override
    public Iterator<Path> iterator() {
        return new AugmentingIterator<Path>(this.wrappedStream.iterator(), this.func);
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    private class NameMappingFunc
    implements Function<Path, List<Path>> {
        private Renderers renderers;

        public NameMappingFunc(Renderers renderers) {
            this.renderers = renderers;
        }

        @Override
        public List<Path> apply(Path path) {
            LinkedList<Path> pathlist = new LinkedList<Path>(this.renderers.getVirtualPathsFor(path));
            ListIterator cursor = pathlist.listIterator();
            while (cursor.hasNext()) {
                Path next = (Path)cursor.next();
                List<Path> adding = this.renderers.getVirtualPathsFor(next);
                adding.forEach(cursor::add);
            }
            if (pathlist.size() == 0) {
                return null;
            }
            return pathlist;
        }
    }
}

