/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class TopicParser {
    private final Path file;
    static final Parser parser = Parser.builder().build();
    private String topicName;

    public TopicParser(Path file) {
        this.file = file;
        try {
            HeV hev = new HeV();
            VisitHandler vh = new VisitHandler(Heading.class, (Visitor)hev);
            NodeVisitor nv = new NodeVisitor(new VisitHandler[]{vh});
            String s = Files.readString(file);
            Document md = parser.parse(s);
            nv.visit((Node)md);
            this.topicName = hev.headings.size() > 0 ? hev.headings.get(0).getText().toString() : "NO HEADING";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    private static final class HeV
    implements Visitor<Heading> {
        public List<Heading> headings = new ArrayList<Heading>();

        private HeV() {
        }

        public void visit(Heading node) {
            this.headings.add(node);
        }
    }
}

