/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model;

import io.virtdata.docsys.metafs.fs.renderfs.api.MarkdownStringer;
import io.virtdata.docsys.metafs.fs.renderfs.api.RendererIO;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.Versioned;
import io.virtdata.docsys.metafs.fs.renderfs.model.ActualFsView;
import io.virtdata.docsys.metafs.fs.renderfs.model.Topic;
import io.virtdata.docsys.metafs.fs.renderfs.model.TopicFinder;
import io.virtdata.docsys.metafs.fs.renderfs.model.properties.ListView;
import io.virtdata.docsys.metafs.fs.renderfs.model.properties.PathView;
import io.virtdata.docsys.metafs.fs.renderfs.model.properties.TreeView;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ViewModel
implements Versioned,
MarkdownStringer {
    private Path target;
    private long version;
    private ViewModel inner;
    private RenderedContent rendered;

    public ViewModel(Path sourcePath, Path targetPath) {
        this.version = RendererIO.mtimeFor(sourcePath);
        this.target = targetPath;
    }

    public Path getTarget() {
        return this.target;
    }

    public ActualFsView getFs() {
        return new ActualFsView(this.target, this.version);
    }

    public List<Path> getBreadcrumbs() {
        ArrayList<Path> paths = new ArrayList<Path>();
        this.target.iterator().forEachRemaining(paths::add);
        return paths;
    }

    public PathView getPath() {
        return new PathView(this.target);
    }

    public ListView<Path> getPaths() {
        List nontemplatefiles = this.getFs().getPaths().stream().filter(p -> !p.getFileName().toString().matches(".*?\\._.*+")).collect(Collectors.toList());
        return new ListView<Path>(nontemplatefiles);
    }

    public TreeView getFileTree() {
        return new TreeView(this);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String asMarkdown() {
        return "```\n" + this.toString() + "\n```\n";
    }

    public void setInner(ViewModel innerRender) {
        this.inner = innerRender;
    }

    public ViewModel getInner() {
        return this.inner;
    }

    public void setRendered(RenderedContent rendered) {
        this.rendered = rendered;
    }

    public RenderedContent getRendered() {
        return this.rendered;
    }

    public String toString() {
        return "ViewModel{target=" + this.target.toString() + ", version=" + this.version + "}";
    }

    public List<Topic> getTopics() {
        return TopicFinder.getTopics(this.target);
    }
}

