/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.renderers;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.ExceptionContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.HTMLRenderedException;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.MarkdownRenderedException;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.StringContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.RenderingScope;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateView;
import io.virtdata.docsys.metafs.fs.renderfs.model.ViewModel;
import java.util.ArrayList;

public class MustacheProcessor
implements TemplateCompiler {
    public static final Mustache.Compiler compiler = Mustache.compiler();

    public String toString() {
        return "\ufe37";
    }

    @Override
    public Renderer apply(TemplateView templateView) {
        return new MustacheRenderer(templateView);
    }

    public static class MustacheRenderer
    implements Renderer {
        private final TemplateView templateView;
        private Template compiledTemplate;

        public MustacheRenderer(TemplateView templateView) {
            this.templateView = templateView;
        }

        @Override
        public RenderedContent apply(RenderingScope scope) {
            ViewModel viewModel = null;
            try {
                if (this.compiledTemplate == null) {
                    this.compiledTemplate = compiler.compile(this.templateView.getRawTemplate());
                }
                viewModel = scope.getViewModel();
                String renderedText = this.compiledTemplate.execute((Object)viewModel);
                return new StringContent(renderedText, this.getVersion(), scope);
            }
            catch (Exception e) {
                ArrayList<String> details = new ArrayList<String>();
                if (viewModel != null) {
                    details.add("View Model:");
                    details.add(viewModel.toString());
                }
                details.add("Template Path:");
                details.add(this.templateView.getTemplatePath().toString());
                details.add("Raw Template:");
                details.add(this.templateView.getRawTemplate());
                if (viewModel.getTarget().toString().endsWith(".md")) {
                    return new MarkdownRenderedException(e, this.templateView, viewModel, scope, details.toArray());
                }
                if (viewModel.getTarget().toString().endsWith(".html")) {
                    return new HTMLRenderedException(e, this.templateView, viewModel, scope, details.toArray());
                }
                return new ExceptionContent(e, this.getVersion(), scope, details.toArray());
            }
        }

        @Override
        public long getVersion() {
            return this.templateView.getVersion();
        }

        @Override
        public String wrapError(String error) {
            return "Mustache Error\n" + error;
        }
    }
}

