/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.walkers;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.function.Predicate;

public class VirtTreeWalker {
    public static void walk(Path p, PathVisitor v, Predicate<String> filter) {
        try {
            FileSystemProvider provider = p.getFileSystem().provider();
            DirectoryStream<Path> paths = provider.newDirectoryStream(p, entry -> true);
            for (Path path : paths) {
                if (!filter.test(path.toString())) continue;
                v.visit(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PathVisitor {
        public void visit(Path var1);
    }
}

