/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.api;

import io.virtdata.docsys.api.PathDescriptor;
import java.nio.file.Path;

public class DocPath
implements PathDescriptor {
    private final Path of;
    private final String descriptiveName;
    private int priority;

    public static DocPath from(Path path, String descriptiveName, int priority) {
        return new DocPath(path, descriptiveName, priority);
    }

    public DocPath(Path of, String descriptiveName, int priority) {
        this.of = of;
        this.descriptiveName = descriptiveName;
        this.priority = priority;
    }

    @Override
    public Path getPath() {
        return this.of;
    }

    @Override
    public String getName() {
        return this.descriptiveName;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(PathDescriptor o) {
        int diff = Integer.compare(this.getPriority(), o.getPriority());
        if (diff != 0) {
            return diff;
        }
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "DocPath{of=" + this.of + ", descriptiveName='" + this.descriptiveName + "', priority=" + this.priority + "}";
    }
}

