/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import io.virtdata.docsys.api.DocPaths;
import io.virtdata.docsys.api.PathDescriptor;
import io.virtdata.docsys.api.WebServiceObject;
import io.virtdata.docsys.core.EndpointLoader;
import io.virtdata.docsys.handlers.FavIconHandler;
import io.virtdata.docsys.metafs.fs.layerfs.LayerFS;
import io.virtdata.docsys.metafs.fs.renderfs.api.FileRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderFS;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.MarkdownProcessor;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.MustacheProcessor;
import io.virtdata.docsys.metafs.fs.virtual.VirtFS;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DocServer.class);
    private final List<Path> basePaths = new ArrayList<Path>();
    private final List<Class> servletClasses = new ArrayList<Class>();
    private ServletContextHandler contextHandler;
    private ServletHolder servlets;
    private String bindHost = "localhost";
    private int bindPort = 12345;

    public DocServer withHost(String bindHost) {
        this.bindHost = bindHost;
        return this;
    }

    public DocServer withPort(int bindPort) {
        this.bindPort = bindPort;
        return this;
    }

    public DocServer addWebObject(Class ... objects) {
        this.servletClasses.addAll(Arrays.asList(objects));
        String servletClasses = this.servletClasses.stream().map(Class::getCanonicalName).collect(Collectors.joining(","));
        this.getServlets().setInitParameter("jersey.config.server.provider.classnames", servletClasses);
        return this;
    }

    public void LoadDynamicEndpoints() {
        List<DocPaths> docPathLists = EndpointLoader.loadPathDescriptors();
        ArrayList<PathDescriptor> docPaths = new ArrayList<PathDescriptor>();
        for (DocPaths docPaths2 : docPathLists) {
            docPaths.addAll(docPaths2.getPathDescriptors());
        }
        docPaths.sort(Comparable::compareTo);
        for (PathDescriptor pathDescriptor : docPaths) {
            logger.info("Adding doc path " + pathDescriptor);
            this.addPaths(pathDescriptor.getPath());
        }
        logger.info("No more doc paths.");
        List<WebServiceObject> serviceObjects = EndpointLoader.loadWebServiceObjects();
        for (WebServiceObject serviceObject : serviceObjects) {
            logger.info("Adding web service object: " + serviceObject.toString());
            this.addWebObject(serviceObject.getClass());
        }
        logger.info("No more service objects.");
    }

    private ServletContextHandler getContextHandler() {
        if (this.contextHandler == null) {
            this.contextHandler = new ServletContextHandler();
            this.contextHandler.setContextPath("/");
        }
        return this.contextHandler;
    }

    private ServletHolder getServlets() {
        if (this.servlets == null) {
            this.servlets = this.getContextHandler().addServlet(ServletContainer.class, "/*");
        }
        return this.servlets;
    }

    public DocServer addPaths(Path ... paths) {
        for (Path path : paths) {
            try {
                path.getFileSystem().provider().checkAccess(path, AccessMode.READ);
                this.basePaths.add(path);
            }
            catch (Exception e) {
                logger.error("Unable to access path " + path.toString());
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public void run() {
        Server server = new Server(this.bindPort);
        HandlerList handlers = new HandlerList();
        if (this.basePaths.size() == 0 && this.servletClasses.size() == 0) {
            logger.info("No service endpoints or doc paths have been added. Loading dynamically.");
            this.LoadDynamicEndpoints();
            if (this.basePaths.size() == 0 && this.servletClasses.size() == 0) {
                throw new InvalidParameterException("There must be at least one servlet class or doc path");
            }
        }
        for (Path path : this.basePaths) {
            Path icon = path.resolve("/favicon.ico");
            if (!Files.exists(icon, new LinkOption[0])) continue;
            FavIconHandler favIconHandler = new FavIconHandler(this.basePaths.get(0) + "/favicon.ico", false);
            handlers.addHandler((Handler)favIconHandler);
            break;
        }
        LayerFS layerfs = new LayerFS("layers");
        for (Path basePath : this.basePaths) {
            VirtFS vfs = new VirtFS(basePath, "virt:" + basePath.toString());
            Connector[] rfs = new RenderFS(vfs, "render:" + basePath.toString());
            MustacheProcessor mustache = new MustacheProcessor();
            MarkdownProcessor mdToHtml = new MarkdownProcessor();
            FileRenderer mustacheMarkdown = new FileRenderer("._md", ".md", false, mustache);
            FileRenderer toMdFragment = new FileRenderer("._md", ".mdf", false, mustache);
            FileRenderer markdownHtml = new FileRenderer(".md", "._html", false, mdToHtml);
            FileRenderer mustacheHtml = new FileRenderer("._html", ".html", false, mustache);
            FileRenderer mustacheJson = new FileRenderer("._json", ".json", false, mustache);
            rfs.addRenderers(mustacheMarkdown, mustacheHtml, mustacheJson, markdownHtml, toMdFragment);
            layerfs.addLayer((FileSystem)rfs);
        }
        PathResource pathResource = new PathResource(layerfs.getRootPath());
        logger.info("Setting root path of server: " + pathResource.toString());
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirAllowed(true);
        resourceHandler.setAcceptRanges(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setRedirectWelcome(true);
        resourceHandler.setBaseResource((Resource)pathResource);
        resourceHandler.setCacheControl("no-cache");
        handlers.addHandler((Handler)resourceHandler);
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setShowContexts(true);
        defaultHandler.setServeIcon(false);
        handlers.addHandler((Handler)defaultHandler);
        if (this.servletClasses.size() > 0) {
            logger.info("adding " + this.servletClasses.size() + " context handlers");
            handlers.addHandler((Handler)this.getContextHandler());
        } else {
            logger.info("No context handlers defined, not adding context container.");
        }
        server.setHandler((Handler)handlers);
        for (Connector connector : server.getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            logger.info("Setting idle timeout for " + connector.toString() + " to 300,000ms");
            ((AbstractConnector)connector).setIdleTimeout(300000L);
        }
        try {
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

