/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.core;

import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFileChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetaFS
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(MetaFS.class);
    protected boolean isReadOnly = true;

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return null;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return null;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return null;
    }

    public Path getRootPath() {
        return new MetaPath(this, "/", new String[0]);
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new MetaPath(this, first, more);
    }

    public void checkAccess(Path path, AccessMode[] modes) throws IOException {
        throw new RuntimeException("Implement me (checkAccess) for " + path.getFileSystem().toString());
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        SeekableByteChannel seekableByteChannel = this.newByteChannel(path, options, attrs);
        return new VirtualFileChannel(seekableByteChannel);
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        logger.debug("newInputStream for " + path);
        HashSet<OpenOption> optionSet = new HashSet<OpenOption>(Arrays.asList(options));
        SeekableByteChannel seekableByteChannel = this.newByteChannel(path, optionSet, new FileAttribute[0]);
        InputStream inputStream = Channels.newInputStream(seekableByteChannel);
        return inputStream;
    }

    public abstract SeekableByteChannel newByteChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IOException;

    public abstract String getName();

    public String toString() {
        return this.getName();
    }
}

