/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.layerfs;

import io.virtdata.docsys.metafs.core.MetaFSProvider;
import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.layerfs.LayerFS;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerFSProvider
extends MetaFSProvider {
    private static LayerFSProvider instance;
    private final Logger logger = LoggerFactory.getLogger(LayerFSProvider.class);

    private LayerFSProvider() {
    }

    public static synchronized LayerFSProvider get() {
        if (instance == null) {
            instance = new LayerFSProvider();
        }
        return instance;
    }

    @Override
    public synchronized FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        boolean readonly = true;
        LayerFS fs = new LayerFS(uri.toString());
        fs.setWritable(env != null && env.get("writable").toString().equals("true"));
        return fs;
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        MetaPath metapath = this.assertMetaPath(path);
        LayerFS layerFS = this.assertLayerFS(metapath);
        return layerFS.newByteChannel(path, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        MetaPath metapath = this.assertMetaPath(dir);
        LayerFS layerFS = this.assertLayerFS(metapath);
        HashSet<String> names = new HashSet<String>();
        final HashSet<Path> paths = new HashSet<Path>();
        IOException possibleException = null;
        int foundDirectoryCount = 0;
        for (FileSystem fs : layerFS.getWrappedFilesystems()) {
            Path fsSpecificPath = fs.getPath(metapath.toString(), new String[0]);
            try {
                DirectoryStream<Path> dsp = fs.provider().newDirectoryStream(fsSpecificPath, filter);
                ++foundDirectoryCount;
                for (Path path : dsp) {
                    if (names.contains(path.toString())) continue;
                    names.add(path.toString());
                    paths.add(path);
                }
            }
            catch (IOException ioe) {
                possibleException = ioe;
            }
        }
        if (foundDirectoryCount == 0) {
            throw new IOException("Unable to find even one directory entry in addLayers for path " + dir);
        }
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return paths.iterator();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return (V)this.acceptFirstSuccess(path, p -> {
            try {
                p.getFileSystem().provider().readAttributes((Path)p, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return p.getFileSystem().provider().getFileAttributeView((Path)p, type, options);
        });
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return (A)this.acceptFirstSuccess(path, p -> {
            try {
                FileSystem fs = p.getFileSystem();
                FileSystemProvider provider = fs.provider();
                Object a = provider.readAttributes((Path)p, type, options);
                return a;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.acceptFirstSuccess(path, p -> {
            try {
                FileSystem fileSystem = p.getFileSystem();
                FileSystemProvider provider = fileSystem.provider();
                Map<String, Object> map = provider.readAttributes((Path)p, attributes, options);
                return map;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> T acceptFirstSuccess(Path path, Function<Path, T> process) {
        MetaPath metapath = this.assertMetaPath(path);
        LayerFS layerFS = this.assertLayerFS(metapath);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (FileSystem wrappedFilesystem : layerFS.getWrappedFilesystems()) {
            try {
                Path localizedpath = wrappedFilesystem.getPath(metapath.toString(), new String[0]);
                return process.apply(localizedpath);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        throw new RuntimeException(exceptions.size() + " exceptions occurred:" + exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(",\n", "\n", "")));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        MetaPath metapath = this.assertMetaPath(path);
        LayerFS layerFS = this.assertLayerFS(metapath);
        layerFS.checkAccess(path, modes);
    }

    private Path findFirstWritablePath(Path toWrite, List<FileSystem> fileSystems) {
        for (FileSystem fs : fileSystems) {
            if (fs.isReadOnly()) continue;
            return fs.getPath(toWrite.toString(), new String[0]);
        }
        throw new RuntimeException("Unable to find a writable filesystem in addLayers.");
    }

    private Path findFirstReadablePath(Path toRead, List<FileSystem> fileSystems) {
        for (FileSystem fileSystem : fileSystems) {
            try {
                Path fsSpecificPath = fileSystem.getPath(toRead.toString(), new String[0]);
                fsSpecificPath.getFileSystem().provider().checkAccess(fsSpecificPath, AccessMode.READ);
                return fsSpecificPath;
            }
            catch (IOException e) {
                this.logger.trace("Did not find readable file " + toRead + " in fs " + fileSystem);
            }
        }
        throw new RuntimeException("Unable to find a readable " + toRead + " in any addLayer");
    }

    private LayerFS assertLayerFS(MetaPath path) {
        if (!(path.getFileSystem() instanceof LayerFS)) {
            throw new RuntimeException("Unable to do LayerFS operations on Path from filesystem of type " + path.getFileSystem().getClass().getCanonicalName());
        }
        return (LayerFS)path.getFileSystem();
    }

    private MetaPath assertMetaPath(Path path) {
        if (!(path instanceof MetaPath)) {
            throw new InvalidParameterException("Unable to do MetaPath operations on Path of type " + path.getClass().getCanonicalName());
        }
        return (MetaPath)path;
    }
}

