/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.AccessMode;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileContentRenderer {
    private static final Logger logger = LoggerFactory.getLogger(FileContentRenderer.class);

    abstract Pattern getSourcePattern();

    abstract Pattern getTargetPattern();

    public boolean matchesSource(Path p) {
        Pattern sourcePattern = this.getSourcePattern();
        Matcher matcher = sourcePattern.matcher(p.toString());
        boolean matches = matcher.matches();
        return matches;
    }

    public boolean matchesTarget(Path p) {
        Pattern targetPattern = this.getTargetPattern();
        Matcher matcher = targetPattern.matcher(p.toString());
        return matcher.matches();
    }

    public boolean hasSource(Path p) {
        Path sourcePath = this.getSourcePath(p);
        try {
            sourcePath.getFileSystem().provider().checkAccess(sourcePath, AccessMode.READ);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean canRender(Path p) {
        boolean canRender;
        if (this.isWrapperPath(p)) {
            return false;
        }
        boolean matchesTarget = this.matchesTarget(p);
        boolean hasSource = this.hasSource(p);
        boolean bl = canRender = matchesTarget && hasSource;
        if (canRender) {
            logger.info("CANRENDER " + p + " (" + this + ")");
        }
        return canRender;
    }

    abstract boolean isWrapperPath(Path var1);

    abstract Path getSourcePath(Path var1);

    abstract Path getRenderedTargetName(Path var1);

    abstract RenderedContent render(Path var1, Path var2, Supplier<ByteBuffer> var3);

    private RenderedContent getRendered(Path targetPath) {
        Path sourcePath = this.getSourcePath(targetPath);
        if (sourcePath != null) {
            try {
                ByteBufferSupplier inputSupplier = new ByteBufferSupplier(sourcePath);
                RenderedContent rendered = this.render(sourcePath, targetPath, inputSupplier);
                return rendered;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public VirtualFile getVirtualFile(Path target) {
        Path delegate = this.getSourcePath(target);
        return new VirtualFile(delegate, target, this.getRendered(target));
    }

    abstract List<Path> getVirtualPathsFor(Path var1);

    private final class ByteBufferSupplier
    implements Supplier<ByteBuffer> {
        private Path sourcePath;

        public ByteBufferSupplier(Path sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public ByteBuffer get() {
            try {
                InputStream inputStream = this.sourcePath.getFileSystem().provider().newInputStream(this.sourcePath, new OpenOption[0]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                inputStream.transferTo(bos);
                return ByteBuffer.wrap(bos.toByteArray()).asReadOnlyBuffer();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

