/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.RenderingScope;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateCompiler;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRenderer
extends FileContentRenderer {
    private static final Logger logger = LoggerFactory.getLogger(FileRenderer.class);
    private final String sourceExtension;
    private final String targetExtension;
    private final Pattern sourceNamePattern;
    private final Pattern targetNamePattern;
    private final boolean isCaseSensitive;
    private TemplateCompiler compiler;

    public FileRenderer(String fromext, String toext, boolean cased, TemplateCompiler compiler) {
        this.compiler = compiler;
        if (!fromext.startsWith(".")) {
            throw new InvalidParameterException("You must provide a source extension in '.xyz' form.");
        }
        if (!toext.startsWith(".")) {
            throw new InvalidParameterException("You must provide a target extension in '.xyz' form.");
        }
        this.isCaseSensitive = cased;
        this.sourceExtension = fromext;
        this.sourceNamePattern = this.toNamePattern(fromext);
        this.targetExtension = toext;
        this.targetNamePattern = this.toNamePattern(toext);
    }

    private Pattern toNamePattern(String fileExtension) {
        Pattern.compile(fileExtension);
        StringBuilder sb = new StringBuilder("(?<basepath>.+)(?<extension>");
        if (this.isCaseSensitive) {
            sb.append(Pattern.quote(fileExtension));
        } else {
            for (int i = 0; i < fileExtension.length(); ++i) {
                String c = fileExtension.substring(i, i + 1);
                if (c.toUpperCase().equals(c.toLowerCase())) {
                    sb.append(Pattern.quote(c));
                    continue;
                }
                sb.append("[").append(c.toLowerCase()).append(c.toUpperCase()).append("]");
            }
            sb.append(")");
        }
        String pattern = sb.toString().replaceAll("\\\\E\\\\Q", "");
        return Pattern.compile(pattern);
    }

    @Override
    public List<Path> getVirtualPathsFor(Path path) {
        ArrayList<Path> vpaths = new ArrayList<Path>();
        if (this.matchesSource(path) && !this.isWrapperPath(path)) {
            Path targetPaths = this.getRenderedTargetName(path);
            vpaths.add(targetPaths);
        }
        return vpaths;
    }

    @Override
    public Pattern getSourcePattern() {
        return this.sourceNamePattern;
    }

    @Override
    public Pattern getTargetPattern() {
        return this.targetNamePattern;
    }

    @Override
    public boolean isWrapperPath(Path p) {
        String filename = p.getName(p.getNameCount() - 1).toString();
        return filename.startsWith("__.") || filename.startsWith("_.");
    }

    public String getSourceExtension() {
        return this.sourceExtension;
    }

    public String getTargetExtension() {
        return this.targetExtension;
    }

    @Override
    public Path getSourcePath(Path targetName) {
        Matcher matcher = this.targetNamePattern.matcher(targetName.toString());
        if (matcher.matches()) {
            String basepath = matcher.group("basepath");
            String extension = matcher.group("extension");
            if (basepath == null || extension == null) {
                throw new RuntimeException("Unable to extract named fields 'basepath' or 'extension' from target name '" + targetName + "' with pattern '" + this.targetNamePattern + "'");
            }
            return targetName.getFileSystem().getPath(basepath + this.sourceExtension, new String[0]);
        }
        return null;
    }

    @Override
    public Path getRenderedTargetName(Path sourceName) {
        Matcher matcher = this.sourceNamePattern.matcher(sourceName.toString());
        if (matcher.matches()) {
            String basepath = matcher.group("basepath");
            String extension = matcher.group("extension");
            if (basepath == null || extension == null) {
                throw new RuntimeException("Unable to extract named fields 'basepath' or 'extension' from source name '" + sourceName + "' with pattern '" + this.sourceNamePattern + "'");
            }
            return sourceName.getFileSystem().getPath(basepath + this.targetExtension, new String[0]);
        }
        throw new RuntimeException("Unable to match source name '" + sourceName + "' with pattern '" + this.sourceNamePattern + "'");
    }

    @Override
    public synchronized RenderedContent render(Path sourcePath, Path targetPath, Supplier<ByteBuffer> byteBuffer) {
        RenderingScope scope = new RenderingScope(sourcePath, targetPath, this.compiler);
        if (!targetPath.toString().endsWith(".mdf")) {
            for (Path template : this.getTemplates(sourcePath)) {
                RenderingScope outer = new RenderingScope(template, template, this.compiler);
                scope = outer.wrap(scope);
            }
        }
        logger.info("SCOPE chain: " + scope.getDiagnosticSummary());
        RenderedContent rendered = scope.getRendered();
        return rendered;
    }

    private LinkedList<Path> getTemplates(Path sourcePath) {
        Path localTmpl2;
        LinkedList<Path> chain = new LinkedList<Path>();
        sourcePath.normalize();
        Path directoryPath = sourcePath.getParent();
        String[] parts = sourcePath.toString().split("\\.");
        String extension = parts[parts.length - 1];
        try {
            localTmpl2 = directoryPath.resolve("_." + extension);
            FileSystemProvider provider = localTmpl2.getFileSystem().provider();
            if (Files.exists(localTmpl2, new LinkOption[0])) {
                chain.addLast(localTmpl2);
            }
        }
        catch (Exception localTmpl2) {
            // empty catch block
        }
        while (directoryPath != null) {
            try {
                localTmpl2 = directoryPath.resolve("__." + extension);
                directoryPath = directoryPath.getParent();
                if (!Files.exists(localTmpl2, new LinkOption[0])) continue;
                chain.addLast(localTmpl2);
            }
            catch (Exception exception) {}
        }
        return chain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.compiler.toString()).append(this.sourceExtension).append("\u2192").append(this.targetExtension).append(")");
        return sb.toString();
    }
}

