/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.RendererIO;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateView;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.Versioned;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.VersionedPath;
import java.nio.file.Path;

public final class SourcePathTemplate
implements TemplateView {
    private final Path sourcePath;
    private final Versioned versions;

    public SourcePathTemplate(Path sourcePath) {
        this.sourcePath = sourcePath;
        this.versions = new VersionedPath(sourcePath);
    }

    @Override
    public long getVersion() {
        return this.versions.getVersion();
    }

    @Override
    public boolean isValid() {
        return this.versions.isValid();
    }

    @Override
    public Path getTemplatePath() {
        return this.sourcePath;
    }

    @Override
    public String getRawTemplate() {
        return RendererIO.readString(this.sourcePath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("source:").append(this.sourcePath.toString());
        sb.append(" @").append(this.getVersion());
        try {
            String rawTemplate = this.getRawTemplate();
            sb.append(" raw template:\n").append(rawTemplate).append("\n");
        }
        catch (Exception e) {
            sb.append("error rendering template: " + e.getMessage());
        }
        return sb.toString();
    }
}

