/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api.rendered;

import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.Versioned;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedContent<T>
implements RenderedContent<T> {
    private static final Logger logger = LoggerFactory.getLogger(CachedContent.class);
    private final Supplier<T> renderer;
    private T cache;
    private Versioned versions;

    public CachedContent(Supplier<T> renderer, Versioned versions) {
        this.renderer = renderer;
        this.versions = versions;
    }

    @Override
    public long getVersion() {
        return this.versions.getVersion();
    }

    @Override
    public boolean isValid() {
        return this.versions.isValid();
    }

    @Override
    public T get() {
        if (this.cache == null) {
            logger.info("CREATING CONTENT");
            this.cache = this.renderer.get();
        }
        return this.cache;
    }

    public String toString() {
        return "content[" + (String)(this.cache == null ? "NULL" : this.cache.toString().length() + " bytes") + "]";
    }
}

