/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api.rendering;

import io.virtdata.docsys.metafs.fs.renderfs.api.SourcePathTemplate;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.ExceptionContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateView;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.VersionData;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.Versioned;
import io.virtdata.docsys.metafs.fs.renderfs.model.ViewModel;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingScope
implements Versioned {
    private static final Logger logger = LoggerFactory.getLogger(RenderingScope.class);
    private final TemplateView templateView;
    private final ViewModel viewModel;
    private final TemplateCompiler compiler;
    private final VersionData versions;
    private RenderingScope innerScope;
    private Renderer renderer;

    public RenderingScope(TemplateView templateView, ViewModel viewModel, TemplateCompiler compiler) {
        this.templateView = templateView;
        this.viewModel = viewModel;
        this.compiler = compiler;
        this.versions = new VersionData(templateView, viewModel);
    }

    public RenderingScope(Path sourcePath, Path targetPath, TemplateCompiler compiler) {
        this(new SourcePathTemplate(sourcePath), new ViewModel(sourcePath, targetPath), compiler);
    }

    public TemplateView getTemplate() {
        return this.templateView;
    }

    public ViewModel getViewModel() {
        return this.viewModel;
    }

    public RenderedContent getRendered() {
        try {
            if (this.innerScope != null) {
                logger.info("RENDERING INNER " + this.innerScope.getTemplate().getTemplatePath() + " -> " + this.innerScope.getViewModel().getTarget());
                this.innerScope.getRendered();
                this.getViewModel().setInner(this.innerScope.getViewModel());
            }
            if (this.getViewModel().getRenderedContent() == null || !this.getViewModel().isValid()) {
                if (this.renderer == null || !this.renderer.isValid()) {
                    logger.info("COMPILING OUTER " + this.getTemplate().getTemplatePath() + " -> " + this.getViewModel().getTarget());
                    this.renderer = (Renderer)this.compiler.apply(this.templateView);
                }
                logger.info("RENDERING OUTER " + this.getTemplate().getTemplatePath() + " -> " + this.getViewModel().getTarget());
                RenderedContent renderedContent = (RenderedContent)this.renderer.apply(this);
                this.getViewModel().setRenderedContent(renderedContent);
            }
            return this.viewModel.getRenderedContent();
        }
        catch (Exception e) {
            String wrappedMessage = this.renderer.wrapError(e.getMessage());
            return new ExceptionContent(this.viewModel, this.templateView, e, new Object[0]);
        }
    }

    public RenderingScope wrap(RenderingScope innerScope) {
        this.innerScope = innerScope;
        this.viewModel.setInner(innerScope.getViewModel());
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[view:").append(this.getViewModel().toString()).append("]");
        int indent = 0;
        RenderingScope scope = this.innerScope;
        while (scope != null) {
            sb.append("\n").append(" ".repeat(++indent));
            sb.append(scope.toString());
            scope = scope.innerScope;
        }
        return sb.toString();
    }

    public String getDiagnosticSummary() {
        StringBuilder sb = new StringBuilder();
        RenderingScope sc = this;
        while (sc != null) {
            sb.append(sc.getTemplate().getTemplatePath());
            sb.append(" ");
            sc = sc.innerScope;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public long getVersion() {
        return this.versions.getVersion();
    }

    @Override
    public boolean isValid() {
        return this.versions.isValid();
    }
}

