/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api.versioning;

import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.Versioned;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;

public class VersionData
implements Versioned {
    private final LongSupplier[] partVersions;
    private final LongSupplier[] dependencyVersions;
    private final List<Versioned> dependencies = new ArrayList<Versioned>();

    public VersionData() {
        this.partVersions = new LongSupplier[]{() -> Long.MIN_VALUE};
        this.dependencyVersions = new LongSupplier[0];
    }

    public VersionData(LongSupplier ... versionSources) {
        this.partVersions = versionSources;
        this.dependencyVersions = new LongSupplier[0];
    }

    public VersionData(Versioned ... dependencies) {
        this.dependencyVersions = new LongSupplier[dependencies.length];
        for (int depidx = 0; depidx < dependencies.length; ++depidx) {
            int lambdaIdx = depidx;
            this.dependencyVersions[depidx] = () -> dependencies[lambdaIdx].getVersion();
        }
        long effectivePartsVersion = this.getMaxDependencyVersion();
        this.partVersions = new LongSupplier[]{() -> effectivePartsVersion};
    }

    public VersionData(LongSupplier thisVersionSource, Versioned ... dependencies) {
        this.partVersions = new LongSupplier[]{thisVersionSource};
        this.dependencyVersions = new LongSupplier[dependencies.length];
        for (int depidx = 0; depidx < dependencies.length; ++depidx) {
            int lambdaIdx = depidx;
            this.dependencyVersions[depidx] = () -> dependencies[lambdaIdx].getVersion();
        }
    }

    @Override
    public long getVersion() {
        long minVersion = Long.MAX_VALUE;
        for (int i = 0; i < this.partVersions.length; ++i) {
            minVersion = Math.min(minVersion, this.partVersions[i].getAsLong());
        }
        return minVersion;
    }

    public long getMaxDependencyVersion() {
        if (this.dependencyVersions.length == 0) {
            return Long.MAX_VALUE;
        }
        long maxVersion = Long.MIN_VALUE;
        for (int i = 0; i < this.dependencyVersions.length; ++i) {
            maxVersion = Math.max(maxVersion, this.dependencyVersions[i].getAsLong());
        }
        return maxVersion;
    }

    public void addVersionDependency(Versioned ... dep) {
        for (Versioned versions : dep) {
            this.dependencies.add(versions);
        }
    }

    @Override
    public boolean isValid() {
        return this.getVersion() >= this.getMaxDependencyVersion();
    }
}

