/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api.versioning;

import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.Versioned;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedObjectCache {
    public static final Logger logger = LoggerFactory.getLogger(VersionedObjectCache.class);
    public static VersionedObjectCache INSTANCE = new VersionedObjectCache();
    private ConcurrentHashMap<String, Versioned> cache = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<? extends Versioned>, ConcurrentHashMap<String, Versioned>> typeMap = new ConcurrentHashMap();

    private VersionedObjectCache() {
    }

    public <T extends Versioned> T getOrCreate(Class<T> clazz, String key, Supplier<T> supplier) {
        ConcurrentHashMap typedMap = this.typeMap.computeIfAbsent(clazz, c -> new ConcurrentHashMap());
        Versioned versioned = (Versioned)typedMap.get(key);
        if (versioned == null || !versioned.isValid()) {
            versioned = (Versioned)supplier.get();
        }
        if (typedMap.containsKey(key)) {
            typedMap.put(key, versioned);
        }
        return (T)((Versioned)clazz.cast(versioned));
    }
}

