/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.fs;

import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderFS;
import io.virtdata.docsys.metafs.fs.virtual.VirtFSProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Set;

public class RenderFSProvider
extends VirtFSProvider {
    protected static RenderFSProvider instance;

    public static synchronized RenderFSProvider get() {
        if (instance == null) {
            instance = new RenderFSProvider();
        }
        return instance;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        RenderFS renderFS = this.assertThisFS(path);
        return renderFS.newInputStream(path, options);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        RenderFS renderFS = this.assertThisFS(path);
        Path syspath = this.getContainerPath(path);
        return renderFS.newByteChannel(path, options, attrs);
    }

    private RenderFS assertThisFS(Path path) {
        if (!(path instanceof MetaPath)) {
            throw new InvalidParameterException("This path must be a MetaPath");
        }
        MetaPath mp = (MetaPath)path;
        if (!(mp.getFileSystem() instanceof RenderFS)) {
            throw new InvalidParameterException("This metapath must be for a RenderFS");
        }
        return (RenderFS)mp.getFileSystem();
    }

    @Override
    public synchronized FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        RenderFS renderFS = this.assertThisFS(path);
        Path syspath = this.getContainerPath(path);
        return renderFS.newFileChannel(path, options, attrs);
    }

    @Override
    public synchronized DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        RenderFS renderFS = this.assertThisFS(dir);
        DirectoryStream<Path> paths = super.newDirectoryStream(dir, filter);
        return renderFS.newDirectoryStream(dir, paths);
    }

    public synchronized BasicFileAttributes readAttributes(Path path, Class type, LinkOption ... options) throws IOException {
        RenderFS renderFS = this.assertThisFS(path);
        return renderFS.readAttributes(path, type, options);
    }

    @Override
    public synchronized Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        RenderFS renderFS = this.assertThisFS(path);
        return renderFS.readAttributes(path, attributes, options);
    }

    @Override
    public synchronized void checkAccess(Path path, AccessMode ... modes) throws IOException {
        RenderFS renderFS = this.assertThisFS(path);
        renderFS.checkAccess(path, modes);
    }

    public synchronized FileAttributeView getFileAttributeView(Path path, Class type, LinkOption ... options) {
        RenderFS renderFS = this.assertThisFS(path);
        return renderFS.getFileAttributeView(path, type, options);
    }
}

