/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.fs;

import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFile;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFileCache {
    private static final Logger logger = LoggerFactory.getLogger(VirtualFileCache.class);
    private final Map<Path, VirtualFile> cacheMap = new HashMap<Path, VirtualFile>();
    private boolean devmode = false;

    public synchronized VirtualFile computeIfAbsent(Path key, Function<? super Path, ? extends VirtualFile> mappingFunction) {
        logger.info("REQUESTFOR " + key);
        try {
            VirtualFile vf = this.cacheMap.get(key);
            if (vf != null) {
                if (!this.devmode && vf.getRenderedContent().isValid()) {
                    logger.trace("REUSED  " + key);
                    return vf;
                }
                logger.info("REFRESH (" + (this.devmode ? "DEV" : vf.getRenderedContent()) + ") " + key);
                vf = mappingFunction.apply(key);
                if (vf == null) {
                    logger.info("NULLREN " + key);
                } else {
                    logger.info("PRESENT " + key);
                    this.cacheMap.put(key, vf);
                }
            } else {
                logger.info("COMPUTE " + key);
                vf = mappingFunction.apply(key);
                if (vf == null) {
                    logger.info("NULLREN " + key);
                } else {
                    logger.info("PRESENT " + key);
                    this.cacheMap.put(key, vf);
                }
            }
            return vf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

