/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model;

import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.VersionedDirectory;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.VersionedObjectCache;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FileTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FileTopicsView;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FlatTopicsView;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.HeaderTopicsView;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.PathTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.Topic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.TopicFinder;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicViews {
    private static final Logger logger = LoggerFactory.getLogger(TopicViews.class);
    private final VersionedObjectCache cache = VersionedObjectCache.INSTANCE;
    private final Path topicScope;

    public TopicViews(Path target) {
        this.topicScope = target;
    }

    public HeaderTopicsView getHeaders() {
        HeaderTopicsView viewOfHeaderTopics = this.cache.getOrCreate(HeaderTopicsView.class, this.topicScope.toString(), this::getHeaderTopics);
        return viewOfHeaderTopics;
    }

    public FlatTopicsView getFlat() {
        FlatTopicsView flatTopicsView = this.cache.getOrCreate(FlatTopicsView.class, this.topicScope.toString(), this::getFlatTopicsView);
        return flatTopicsView;
    }

    public FileTopicsView getFiles() {
        FileTopicsView fileTopicsView = this.cache.getOrCreate(FileTopicsView.class, this.topicScope.toString(), this::getFileTopicsView);
        return fileTopicsView;
    }

    private FileTopicsView getFileTopicsView() {
        List<Topic> fileTopics = TopicFinder.getFileTopics(this.topicScope);
        fileTopics = this.scrunch(fileTopics);
        return new FileTopicsView(fileTopics, new VersionedDirectory(this.topicScope));
    }

    private FlatTopicsView getFlatTopicsView() {
        List<Topic> topicList = TopicFinder.getTopicList(this.topicScope);
        return new FlatTopicsView(topicList, new VersionedDirectory(this.topicScope));
    }

    private HeaderTopicsView getHeaderTopics() {
        List<Topic> topics = TopicFinder.getHeaderTopics(this.topicScope);
        List<Topic> scrunched = this.scrunch(topics);
        return new HeaderTopicsView(scrunched, new VersionedDirectory(this.topicScope));
    }

    private List<Topic> scrunch(List<Topic> topics) {
        Path parent = this.topicScope.getParent();
        FileTopic root = new FileTopic(parent);
        String s = ((PathTopic)root).toString();
        root.addSubTopics(topics);
        LinkedList<FileTopic> mill = new LinkedList<FileTopic>();
        mill.add(root);
        ListIterator<Topic> it = mill.listIterator();
        try {
            while (it.hasNext()) {
                Topic next = (Topic)it.next();
                for (Topic subTopic : next.getSubTopics()) {
                    subTopic.setLevel(next.getLevel() + 1);
                    it.add(subTopic);
                    it.previous();
                }
            }
            logger.info("Completed scrunch");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return root.getSubTopics();
    }
}

