/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model.topics;

import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FileTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.PathTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.Topic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.TopicParser;
import io.virtdata.docsys.metafs.fs.renderfs.walkers.VirtTreeWalker;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTopicVisitor
implements VirtTreeWalker.PathVisitor {
    private static final Logger logger = LoggerFactory.getLogger(FileTopicVisitor.class);
    private final PathTopic root;

    public FileTopicVisitor(Path p) {
        this.root = new FileTopic(p);
        logger.info("VISIT FILE TOPICS for(" + p + ")");
    }

    public List<Topic> getFileTopics() {
        return this.root.getSubTopics();
    }

    @Override
    public void visit(Path p) {
        TopicParser parser = new TopicParser(p);
        LinkedList<Topic> topicsNestedByHeader = parser.getNestedHeaderTopics();
        FileTopic fileTopic = new FileTopic(p);
        if (topicsNestedByHeader.size() > 0) {
            Topic first = topicsNestedByHeader.removeFirst();
            fileTopic.addSubTopics(first.getSubTopics());
            fileTopic.setName(first.getName());
        }
        fileTopic.addSubTopics(topicsNestedByHeader);
        this.root.addSubTopic(fileTopic);
    }
}

