/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model.topics;

import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.VersionData;
import io.virtdata.docsys.metafs.fs.renderfs.api.versioning.VersionedDirectory;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.Topic;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.DocSysIdGenerator;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;

public abstract class PathTopic
implements Topic {
    private final DocSysIdGenerator gen = new DocSysIdGenerator();
    protected final Path path;
    private final VersionData versions;
    protected String name;
    protected LinkedList<Topic> subTopics;
    private static final LinkedList<Topic> NO_SUBTOPICS = new LinkedList();
    private int level;

    public PathTopic(Path path) {
        this.path = path;
        this.versions = new VersionData(new VersionedDirectory(path));
    }

    @Override
    public String getName() {
        try {
            if (this.name == null) {
                String path = this.getPath();
                int i = path.lastIndexOf("/");
                return "unnamed:" + this.getPath().substring(0, i);
            }
            return this.name;
        }
        catch (Exception e) {
            return "OOPS";
        }
    }

    @Override
    public String getId() {
        return this.gen.generateId(this.getName());
    }

    @Override
    public String getPath() {
        String pstr = this.path.toString();
        int i = pstr.lastIndexOf(".");
        if (i < 0) {
            return pstr;
        }
        return pstr.substring(0, i);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public LinkedList<Topic> getSubTopics() {
        return this.subTopics == null ? NO_SUBTOPICS : this.subTopics;
    }

    public void addSubTopics(Collection<Topic> topics) {
        if (this.subTopics == null) {
            this.subTopics = new LinkedList();
        }
        this.subTopics.addAll(topics);
    }

    @Override
    public void addSubTopic(Topic topic) {
        if (this.subTopics == null) {
            this.subTopics = new LinkedList();
        }
        this.subTopics.add(topic);
    }

    public String toString() {
        return "[" + this.getLevel() + "[ " + this.getName() + " ]] : " + this.getPath() + " id:" + this.getId();
    }

    public void setName(String name) {
        this.name = name;
    }
}

