/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model.topics;

import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FileTopicVisitor;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.HeaderTopicVisitor;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.Topic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.TopicTreeVisitor;
import io.virtdata.docsys.metafs.fs.renderfs.walkers.VirtTreeWalker;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicFinder {
    private static final Logger logger = LoggerFactory.getLogger(TopicFinder.class);

    public static List<Topic> getTopicList(Path baseTopicPath) {
        logger.info("GET TOPIC LISTS " + baseTopicPath);
        try {
            HeaderTopicVisitor v = new HeaderTopicVisitor();
            TopicFileFilter f = new TopicFileFilter(".mdf", baseTopicPath);
            Path parent = baseTopicPath.getParent();
            VirtTreeWalker.walk(parent, v, f);
            List<Topic> topics = v.getTopics();
            return topics;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Topic> getHeaderTopics(Path baseTopicPath) {
        logger.info("GET TOPIC TREES" + baseTopicPath);
        try {
            TopicTreeVisitor v = new TopicTreeVisitor(baseTopicPath);
            TopicFileFilter f = new TopicFileFilter(".mdf", baseTopicPath);
            Path parent = baseTopicPath.getParent();
            VirtTreeWalker.walk(parent, v, f);
            return v.getTopicTrees();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Topic> getFileTopics(Path topicScope) {
        logger.info("GET FILE TOPICS " + topicScope);
        try {
            FileTopicVisitor v = new FileTopicVisitor(topicScope);
            TopicFileFilter f = new TopicFileFilter(".mdf", topicScope);
            Path parent = topicScope.getParent();
            VirtTreeWalker.walk(parent, v, f);
            List<Topic> topics = v.getFileTopics();
            return topics;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class TopicFileFilter
    implements DirectoryStream.Filter<Path> {
        private final Path callerPath;
        private final String logicalPathName;
        private String extension;

        public TopicFileFilter(String extension, Path callerPath) {
            this.extension = extension;
            this.callerPath = callerPath;
            int i = this.callerPath.toString().lastIndexOf(".");
            this.logicalPathName = callerPath.toString().substring(0, i);
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            if (entry.equals(this.callerPath)) {
                return false;
            }
            if (entry.toString().startsWith(this.logicalPathName)) {
                return false;
            }
            if (entry.toString().endsWith(this.extension)) {
                return true;
            }
            return entry.getFileSystem().provider().readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]).isDirectory();
        }
    }
}

