/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model.topics;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FileTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.HeaderTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.PathTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.Topic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class TopicParser {
    static final Parser parser = Parser.builder().build();
    private final Path file;
    private List<Heading> headings;

    public TopicParser(Path file) {
        this.file = file;
    }

    private List<Heading> getHeadings() {
        if (this.headings == null) {
            try {
                HeV hev = new HeV();
                VisitHandler vh = new VisitHandler(Heading.class, (Visitor)hev);
                NodeVisitor nv = new NodeVisitor(new VisitHandler[]{vh});
                String s = Files.readString(this.file);
                Document md = parser.parse(s);
                nv.visit((Node)md);
                this.headings = hev.headinglist;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.headings;
    }

    public List<Topic> getHeaderTopics() {
        List<Heading> headings = this.getHeadings();
        return headings.stream().map(h -> new HeaderTopic((Heading)h, this.file)).collect(Collectors.toList());
    }

    public LinkedList<Topic> getNestedHeaderTopics() {
        ArrayDeque<PathTopic> roots = new ArrayDeque<PathTopic>();
        roots.addLast(new FileTopic(this.file));
        ArrayDeque<1> stack = new ArrayDeque<1>();
        stack.addLast(new Heading(){
            {
                this.setLevel(0);
            }
        });
        for (Heading heading : this.getHeadings()) {
            HeaderTopic thistopic = new HeaderTopic(heading, this.file);
            int thislevel = heading.getLevel();
            while (((Topic)roots.peekLast()).getLevel() >= thislevel) {
                roots.removeLast();
            }
            ((Topic)roots.peekLast()).addSubTopic(thistopic);
            roots.addLast(thistopic);
        }
        while (((Topic)roots.peekLast()).getLevel() > ((Topic)roots.peekFirst()).getLevel()) {
            roots.removeLast();
        }
        if (roots.size() != 1) {
            throw new RuntimeException("Struct not as expected after parser walk.");
        }
        return ((Topic)roots.peek()).getSubTopics();
    }

    public String toString() {
        return "TOPICS:" + this.file.toString();
    }

    private static final class HeV
    implements Visitor<Heading> {
        public List<Heading> headinglist = new ArrayList<Heading>();

        private HeV() {
        }

        public void visit(Heading heading) {
            this.headinglist.add(heading);
        }
    }
}

