/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model.topics;

import io.virtdata.docsys.metafs.fs.renderfs.model.topics.FileTopic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.Topic;
import io.virtdata.docsys.metafs.fs.renderfs.model.topics.TopicParser;
import io.virtdata.docsys.metafs.fs.renderfs.walkers.VirtTreeWalker;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class TopicTreeVisitor
implements VirtTreeWalker.PathVisitor {
    private final List<Topic> topicRoots = new ArrayList<Topic>();
    private final Deque<Topic> roots = new ArrayDeque<Topic>();
    private final Deque<String> categories = new ArrayDeque<String>();

    public TopicTreeVisitor(Path baseTopicPath) {
        this.roots.addLast(new FileTopic(baseTopicPath));
    }

    @Override
    public void visit(Path p) {
        TopicParser tp = new TopicParser(p);
        LinkedList<Topic> topicTrees = tp.getNestedHeaderTopics();
        for (Topic topicTree : topicTrees) {
            this.roots.peekLast().addSubTopic(topicTree);
        }
    }

    @Override
    public void preVisitDir(Path path) {
        this.categories.add(path.getName(path.getNameCount() - 1).toString());
    }

    @Override
    public void postVisitDir(Path path) {
        this.categories.removeLast();
    }

    public List<Topic> getTopicTrees() {
        return this.roots.getLast().getSubTopics();
    }
}

