/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.renderers;

import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.CachedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.RenderingScope;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateView;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.DocSysIdGenerator;
import java.util.Arrays;

public class MarkdownRenderer
implements Renderer {
    static final MutableDataHolder OPTIONS = new MutableDataSet().set(HtmlRenderer.GENERATE_HEADER_ID, (Object)true).set(HtmlRenderer.DO_NOT_RENDER_LINKS, (Object)false).set(Parser.EXTENSIONS, Arrays.asList(AnchorLinkExtension.create())).set(AnchorLinkExtension.ANCHORLINKS_SET_ID, (Object)true).set(AnchorLinkExtension.ANCHORLINKS_ANCHOR_CLASS, (Object)"header-anchor");
    protected static final Parser parser = Parser.builder((DataHolder)OPTIONS).build();
    protected static final HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)OPTIONS).htmlIdGeneratorFactory((HeaderIdGeneratorFactory)new DocSysIdGenerator.DocSysIdGeneratorFactory()).build();
    private final Document document;
    private long version;

    public MarkdownRenderer(TemplateView template) {
        this.document = parser.parse(template.getRawTemplate());
    }

    @Override
    public RenderedContent apply(RenderingScope scope) {
        try {
            this.version = scope.getVersion();
            return new CachedContent<String>(() -> renderer.render((Node)this.document), scope);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String wrapError(String error) {
        return "\n```\nMarkdown Error:\n" + error + "\n```\n";
    }

    @Override
    public long getVersion() {
        return 0L;
    }

    @Override
    public boolean isValid() {
        return false;
    }
}

