/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.walkers;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtTreeWalker {
    private static final Logger logger = LoggerFactory.getLogger(VirtTreeWalker.class);

    public static void walk(Path p, PathVisitor v, DirectoryStream.Filter<Path> filter) {
        try {
            logger.info(" TOPIC-WALK > " + p);
            FileSystemProvider provider = p.getFileSystem().provider();
            DirectoryStream<Path> paths = provider.newDirectoryStream(p, r -> true);
            ArrayList<Path> pathlist = new ArrayList<Path>();
            for (Path path : paths) {
                pathlist.add(path);
            }
            for (Path path : pathlist) {
                if (path.getFileSystem().provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
                    v.preVisitDir(path);
                    VirtTreeWalker.walk(path, v, filter);
                    v.postVisitDir(path);
                    continue;
                }
                if (!filter.accept(path)) continue;
                logger.info("----> COMPUTE TOPICS for (" + path + ")");
                v.preVisitFile(path);
                v.visit(path);
                v.postVisitFile(path);
                logger.info("<--- END COMPUTE TOPICS  (" + path + ")");
            }
            logger.info(" TOPIC-WALK < " + p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PathVisitor {
        public void visit(Path var1);

        default public void preVisitFile(Path path) {
        }

        default public void postVisitFile(Path path) {
        }

        default public void preVisitDir(Path path) {
        }

        default public void postVisitDir(Path path) {
        }
    }
}

