/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.parser;

import io.virtdata.ast.VirtDataAST;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.generated.VirtDataLexer;
import io.virtdata.generated.VirtDataParser;
import io.virtdata.parser.VirtDataBuilder;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataDSL {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataDSL.class);

    public static ParseResult parse(String input) {
        try {
            VirtDataAST ast;
            List<VirtDataFlow> flows;
            CodePointCharStream cstream = CharStreams.fromString(input);
            VirtDataLexer lexer = new VirtDataLexer(cstream);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            VirtDataParser parser = new VirtDataParser(tokens);
            VirtDataBuilder astListener = new VirtDataBuilder();
            parser.addParseListener(astListener);
            VirtDataParser.VirtdataFlowContext virtdataFlowContext = parser.virtdataFlow();
            System.out.println(virtdataFlowContext.toStringTree(parser));
            if (astListener.hasErrors()) {
                System.out.println(astListener.getErrorNodes());
            }
            if ((flows = (ast = astListener.getModel()).getFlows()).size() > 1) {
                throw new RuntimeException("Only one flow expected here.");
            }
            if (astListener.hasErrors()) {
                throw new RuntimeException("Error parsing input '" + input + "'");
            }
            return new ParseResult(flows.get(0));
        }
        catch (Exception e) {
            logger.warn("Error while parsing flow:" + e.getMessage());
            return new ParseResult(e);
        }
    }

    public static class ParseResult {
        public Throwable throwable;
        public VirtDataFlow flow;

        public ParseResult(VirtDataFlow flow) {
            this.flow = flow;
        }

        public ParseResult(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

