/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.parser;

import io.virtdata.ast.VirtDataAST;
import io.virtdata.generated.VirtDataLexer;
import io.virtdata.generated.VirtDataParser;
import io.virtdata.parser.VirtDataBuilder;
import java.io.IOException;
import java.io.Reader;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataLanguage {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataLanguage.class);

    public static VirtDataAST parse(String description, Reader input) {
        logger.info("Parsing input '" + description + "'.");
        try {
            CodePointCharStream charStream = CharStreams.fromReader((Reader)input);
            VirtDataLexer lexer = new VirtDataLexer((CharStream)charStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            VirtDataParser parser = new VirtDataParser((TokenStream)tokens);
            VirtDataBuilder astListener = new VirtDataBuilder();
            parser.addParseListener(astListener);
            if (logger.isTraceEnabled()) {
                VirtDataParser.VirtdataRecipeContext virtdataRecipeContext = parser.virtdataRecipe();
                logger.trace("parse tree:\n" + virtdataRecipeContext.toStringTree(parser));
            }
            if (astListener.hasErrors()) {
                System.out.println(astListener.getErrorNodes());
            }
            VirtDataAST virtDataAST = astListener.getModel();
            logger.info("Parsed:\n" + description);
            return virtDataAST;
        }
        catch (IOException ioe) {
            logger.error("Error while parsing input '" + description + "'.", (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
    }
}

