/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.ast;

import io.virtdata.ast.ArgType;

public class StringArg
implements ArgType {
    private final String rawEscapedText;
    private final String unEscapedText;

    public StringArg(String string) {
        this.rawEscapedText = string;
        this.unEscapedText = StringArg.unEscape(string);
    }

    private static String unEscape(String string) {
        String string2 = string.substring(1, string.length() - 1);
        if (string.startsWith("\"")) {
            string2 = string2.replaceAll("\\\\(.)", "$1");
        }
        return string2;
    }

    public String getRawValue() {
        return this.rawEscapedText;
    }

    public String getStringValue() {
        return this.unEscapedText;
    }

    public String toString() {
        return "'" + this.unEscapedText + "'";
    }
}

