/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.parser;

import io.virtdata.ast.VirtDataAST;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.generated.VirtDataLexer;
import io.virtdata.generated.VirtDataParser;
import io.virtdata.parser.VirtDataBuilder;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataDSL {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataDSL.class);

    public static ParseResult parse(String string) {
        try {
            VirtDataAST virtDataAST;
            List<VirtDataFlow> list;
            CodePointCharStream codePointCharStream = CharStreams.fromString((String)string);
            VirtDataLexer virtDataLexer = new VirtDataLexer((CharStream)codePointCharStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)virtDataLexer);
            VirtDataParser virtDataParser = new VirtDataParser((TokenStream)commonTokenStream);
            VirtDataBuilder virtDataBuilder = new VirtDataBuilder();
            virtDataParser.addParseListener(virtDataBuilder);
            VirtDataParser.VirtdataFlowContext virtdataFlowContext = virtDataParser.virtdataFlow();
            logger.trace("parse tree: " + virtdataFlowContext.toStringTree(virtDataParser));
            if (virtDataBuilder.hasErrors()) {
                System.out.println(virtDataBuilder.getErrorNodes());
            }
            if ((list = (virtDataAST = virtDataBuilder.getModel()).getFlows()).size() > 1) {
                throw new RuntimeException("Only one flow expected here.");
            }
            if (virtDataBuilder.hasErrors()) {
                throw new RuntimeException("Error parsing input '" + string + "'");
            }
            return new ParseResult(list.get(0));
        }
        catch (Exception exception) {
            logger.warn("Error while parsing flow:" + exception.getMessage());
            return new ParseResult(exception);
        }
    }

    public static class ParseResult {
        public Throwable throwable;
        public VirtDataFlow flow;

        public ParseResult(VirtDataFlow virtDataFlow) {
            this.flow = virtDataFlow;
        }

        public ParseResult(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

