/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.ast;

import io.virtdata.ast.BooleanArg;
import io.virtdata.ast.DoubleArg;
import io.virtdata.ast.FloatArg;
import io.virtdata.ast.FunctionCall;
import io.virtdata.ast.IntegerArg;
import io.virtdata.ast.LongArg;
import io.virtdata.ast.RefArg;
import io.virtdata.ast.StringArg;
import io.virtdata.ast.VariableRef;

public interface ArgType {

    public static enum TypeName {
        RefArg(RefArg.class, VariableRef.class),
        FunctionCall(FunctionCall.class, FunctionCall.class),
        StringArg(StringArg.class, String.class),
        FloatArg(FloatArg.class, Float.TYPE),
        DoubleArg(DoubleArg.class, Double.TYPE),
        LongArg(LongArg.class, Long.TYPE),
        IntegerArg(IntegerArg.class, Integer.TYPE),
        BooleanArg(BooleanArg.class, Boolean.TYPE);

        private final Class<?> valueClass;
        private final Class<?> typeClass;

        private TypeName(Class<?> clazz, Class<?> clazz2) {
            this.typeClass = clazz;
            this.valueClass = clazz2;
        }

        public Class<?> getTypeClass() {
            return this.typeClass;
        }

        public Class<?> getValueClass() {
            return this.valueClass;
        }

        public static TypeName valueOf(ArgType argType) {
            for (TypeName typeName : TypeName.values()) {
                if (typeName.typeClass != argType.getClass()) continue;
                return typeName;
            }
            throw new RuntimeException("Unable to resolve TypeName in " + ArgType.class.getCanonicalName() + " for " + argType.getClass().getCanonicalName());
        }
    }
}

