// This file is auto-generated.
package io.virtdata.basicsmappers.from_long.to_double;

import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class HashedDoubleRangeAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "HashedDoubleRange";
  }

  public String getPackageName() {
    return "io.virtdata.basicsmappers.from_long.to_double";
  }

  public String getClassJavadoc() {
    return "<p>This simulates a uniform sample from a range of double values\n"
            + "via long hashing. This function attempts to take a double\n"
            + "unit interval value from a long/long division over the whole\n"
            + "range of long values but via double value types, thus providing\n"
            + "a very linear sample. This means that the range of double\n"
            + "values to be accessed will not fall along all possible doubles,\n"
            + "but will still provide suitable values for ranges close to\n"
            + "high-precision points in the IEEE floating point number line.\n"
            + "This suffices for most reasonable ranges in practice outside\n"
            + "of scientific computing, where large exponents put adjacent\n"
            + "IEEE floating point values much further apart.</p>\n"
            + "\n"
            + "<p>This should be consider the default double range sampling\n"
            + "function for most uses, when the exponent is not needed for\n"
            + "readability.</p>\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "double";
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("HashedDoubleRange", "", 
            new LinkedHashMap<String, String>() {{
              put("min","double");
              put("max","double");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
