// This file is auto-generated.
package io.virtdata.stathelpers.aliasmethod;

import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class AliasElementSamplerAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "AliasElementSampler";
  }

  public String getPackageName() {
    return "io.virtdata.stathelpers.aliasmethod";
  }

  public String getClassJavadoc() {
    return "Uses the alias sampling method to encode and sample from discrete probabilities,\n"
            + "even over larger sets of data. This form requires a unit interval sample value\n"
            + "between 0.0 and 1.0. Assuming the maximal amount of memory is used for distinct\n"
            + "outcomes N, a memory buffer of N*16 bytes is required for this implementation,\n"
            + "requiring 32MB of memory for 1M entries.\n"
            + "\n"
            + "This sampler should be shared between threads, and will be by default, in order\n"
            + "to avoid many instances of a 32MB buffer on heap.\n";
  }

  public String getInType() {
    return "double";
  }

  public String getOutType() {
    return "T";
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("AliasElementSampler", "Setup an alias table for T type objects.\n"
              + "@param biases An array of the unfair die model values\n"
              + "@param elements An array of elements of type T, two values per bias value. index 2n is bot, index 2n+1 is top.\n", 
            new LinkedHashMap<String, String>() {{
              put("biases","double[]");
              put("elements","T[]");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("AliasElementSampler", "", 
            new LinkedHashMap<String, String>() {{
              put("elements","java.util.Collection<T>");
              put("weightFunction","java.util.function.Function<T,java.lang.Double>");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("AliasElementSampler", "", 
            new LinkedHashMap<String, String>() {{
              put("events","java.util.List<io.virtdata.stathelpers.ElemProbD<T>>");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
