/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_double;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.api.DataMapper;
import io.virtdata.basicsmappers.from_long.to_long.Hash;

@ThreadSafeMapper
public class HashedRangedToNonuniformDouble
implements DataMapper<Double> {
    private final long min;
    private final long max;
    private final double length;
    private final Hash hash = new Hash();

    public HashedRangedToNonuniformDouble(long min, long max) {
        this(min, max, System.nanoTime());
    }

    public HashedRangedToNonuniformDouble(long min, long max, long seed) {
        if (max <= min) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = min;
        this.max = max;
        this.length = (double)max - (double)min;
    }

    public Double get(long input) {
        long bitImage = this.hash.applyAsLong(input);
        double value = Math.abs(Double.longBitsToDouble(bitImage));
        while (!Double.isFinite(value)) {
            bitImage = this.hash.applyAsLong(++input);
            value = Math.abs(Double.longBitsToDouble(bitImage));
        }
        value %= this.length;
        return value += (double)this.min;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }
}

