/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_int;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.basicsmappers.from_long.to_int.Hash;
import io.virtdata.util.ResourceFinder;
import java.util.List;
import java.util.function.LongToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class HashedLineToInt
implements LongToIntFunction {
    private static final Logger logger = LoggerFactory.getLogger(HashedLineToInt.class);
    private final List<String> lines;
    private final String filename;
    private final Hash intHash;

    public HashedLineToInt(String filename) {
        this.filename = filename;
        this.lines = ResourceFinder.readDataFileLines((String)filename);
        this.intHash = new Hash();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public int applyAsInt(long value) {
        int itemIdx = this.intHash.applyAsInt(value) % this.lines.size();
        String item = this.lines.get(itemIdx);
        return Integer.valueOf(item);
    }
}

