/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
public class ListTemplate
implements LongFunction<List<String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<String> valueFunc;

    public ListTemplate(LongToIntFunction sizeFunc, LongFunction<String> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc;
    }

    @Override
    public List<String> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.valueFunc.apply(value + (long)i));
        }
        return list;
    }
}

