/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_time_types;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.basicsmappers.DateTimeFormats;
import java.util.UUID;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class ToFinestTimeUUID
implements LongFunction<UUID> {
    private final long node;
    private final long clock;
    private final long baseTicks;

    @Example(value={"ToFinestTimeUUID()", "basetime 0, computed node data, empty clock data"})
    public ToFinestTimeUUID() {
        this.node = 0L;
        this.clock = 0L;
        this.baseTicks = 0L;
    }

    @Example(value={"ToFinestTimeUUID(5234)", "basetime 0, specified node data (5234), empty clock data"})
    public ToFinestTimeUUID(long node) {
        this.node = node;
        this.clock = 0L;
        this.baseTicks = 0L;
    }

    @Example(value={"ToFinestTimeUUID(31,337)", "basetime 0, specified node data (31) and clock data (337)"})
    public ToFinestTimeUUID(long node, long clock) {
        this.node = node;
        this.clock = clock;
        this.baseTicks = 0L;
    }

    @Example(value={"ToFinestTimeUUID('2017-01-01T23:59:59')", "specified basetime, computed node data, empty clock data"})
    public ToFinestTimeUUID(String baseTimeSpec) {
        this.node = 0L;
        this.clock = 0L;
        this.baseTicks = DateTimeFormats.parseEpochTimeToTimeUUIDTicks(baseTimeSpec);
    }

    @Example(value={"ToFinestTimeUUID('2012',12345)", "basetime at start if 2012, with node data 12345, empty clock data"})
    public ToFinestTimeUUID(String baseTimeSpec, long node) {
        this.node = node;
        this.clock = 0L;
        this.baseTicks = DateTimeFormats.parseEpochTimeToTimeUUIDTicks(baseTimeSpec);
    }

    @Example(value={"ToFinestTimeUUID('20171231T1015.243',123,456)", "ms basetime, specified node and clock data"})
    public ToFinestTimeUUID(String baseTimeSpec, long node, long clock) {
        this.node = node;
        this.clock = clock;
        this.baseTicks = DateTimeFormats.parseEpochTimeToTimeUUIDTicks(baseTimeSpec);
    }

    private static long msbBitsFor(long timeClicks) {
        return 0x1000L | (0xFFF000000000000L & timeClicks) >>> 48 | (0xFFFF00000000L & timeClicks) >>> 16 | (0xFFFFFFFFL & timeClicks) << 32;
    }

    private static long lsbBitsFor(long node, long clock) {
        return (clock & 0x3FFFL) << 48 | Long.MIN_VALUE | node;
    }

    @Override
    public UUID apply(long timeClicks) {
        return new UUID(ToFinestTimeUUID.msbBitsFor(timeClicks + this.baseTicks), ToFinestTimeUUID.lsbBitsFor(this.node, this.clock));
    }
}

