/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_time_types;

import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ToFinestTimeUUIDAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "ToFinestTimeUUID";
    }

    public String getPackageName() {
        return "io.virtdata.basicsmappers.from_long.to_time_types";
    }

    public String getClassJavadoc() {
        return "Converts a count of 100ns intervals from 1582 Julian to a Type1 TimeUUID\naccording to <a href=\"https://www.ietf.org/rfc/rfc4122.txt\">RFC 4122</a>.\nThis allows you to access the finest unit of resolution for the\npurposes of simulating a large set of unique timeuuid values. This offers\n10000 times more unique values per ms than {@link ToEpochTimeUUID}.\n\nFor the variants that have an String argument in the constructor, this is\na parsable datetime that is used as the base time for all produced values.\nSetting this allows you to set the start of the time range for all timeuuid\nvalues produced. All times are parsed for UTC. All time use ISO date ordering,\nmeaning that the most significant fields always go before the others.\n\nThe valid formats, in joda specifier form are:\n\n<ol>\n<li>yyyy-MM-dd HH:mm:ss.SSSZ, for example: 2015-02-28 23:30:15.223</li>\n<li>yyyy-MM-dd HH:mm:ss, for example 2015-02-28 23:30:15</li>\n<li>yyyyMMdd'T'HHmmss.SSSZ, for example: 20150228T233015.223</li>\n<li>yyyyMMdd'T'HHmmssZ, for example: 20150228T233015</li>\n<li>yyyy-MM-dd, for example: 2015-02-28</li>\n<li>yyyyMMdd, for example: 20150228</li>\n<li>yyyyMM, for example: 201502</li>\n<li>yyyy, for example: 2015</li>\n</ol>\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "java.util.UUID";
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a per-host node and empty clock data.\nThe node and clock components are seeded from network interface data. In this case,\nthe clock data is not seeded uniquely.\n", (Map)new LinkedHashMap<String, String>(){}, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToFinestTimeUUID()");
                                this.add("basetime 0, computed node data, empty clock data");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and empty clock data.\nThis is useful for testing so that you can know that values are verifiable, even though\nin non-testing practice, you would rely on some form of entropy per-system to provide\nmore practical dispersion of values over reboots, etc.\n\n@param node a fixture value for testing that replaces node and clock bits\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("node", "long");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToFinestTimeUUID(5234)");
                                this.add("basetime 0, specified node data (5234), empty clock data");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and specific clock data.\nThis is useful for testing so that you can know that values are verifiable, even though\nin non-testing practice, you would rely on some form of entropy per-system to provide\nmore practical dispersion of values over reboots, etc.\n\n@param node  a fixture value for testing that replaces node bits\n@param clock a fixture value for testing that replaces clock bits\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("node", "long");
                        this.put("clock", "long");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToFinestTimeUUID(31,337)");
                                this.add("basetime 0, specified node data (31) and clock data (337)");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a per-host node and empty clock data.\nThe node and clock components are seeded from network interface data. In this case,\nthe clock data is not seeded uniquely.\n\n@param baseTimeSpec - a string specification for the base time value\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("baseTimeSpec", "java.lang.String");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToFinestTimeUUID('2017-01-01T23:59:59')");
                                this.add("specified basetime, computed node data, empty clock data");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and empty clock data.\nThis is useful for testing so that you can know that values are verifiable, even though\nin non-testing practice, you would rely on some form of entropy per-system to provide\nmore practical dispersion of values over reboots, etc.\n\n@param baseTimeSpec - a string specification for the base time value\n@param node         a fixture value for testing that replaces node and clock bits\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("baseTimeSpec", "java.lang.String");
                        this.put("node", "long");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToFinestTimeUUID('2012',12345)");
                                this.add("basetime at start if 2012, with node data 12345, empty clock data");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and specific clock data.\nThis is useful for testing so that you can know that values are verifiable, even though\nin non-testing practice, you would rely on some form of entropy per-system to provide\nmore practical dispersion of values over reboots, etc.\n\n@param node         a fixture value for testing that replaces node bits\n@param clock        a fixture value for testing that replaces clock bits\n@param baseTimeSpec - a string specification for the base time value\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("baseTimeSpec", "java.lang.String");
                        this.put("node", "long");
                        this.put("clock", "long");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToFinestTimeUUID('20171231T1015.243',123,456)");
                                this.add("ms basetime, specified node and clock data");
                            }
                        });
                    }
                }));
            }
        };
    }
}

