/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.nondeterministic;

import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
public class ThreadNumToLong
implements LongUnaryOperator {
    private static final Pattern pattern = Pattern.compile("^.*?(\\d+).*$");
    private ThreadLocal<Long> threadLocalInt = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            Matcher matcher = pattern.matcher(Thread.currentThread().getName());
            if (matcher.matches()) {
                return Long.valueOf(matcher.group(1));
            }
            throw new RuntimeException("Unable to match a digit sequence in thread name:" + Thread.currentThread().getName());
        }
    };

    @Override
    public long applyAsLong(long input) {
        return this.threadLocalInt.get();
    }
}

