/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.stathelpers.aliasmethod;

import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AliasElementSamplerAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "AliasElementSampler";
    }

    public String getPackageName() {
        return "io.virtdata.stathelpers.aliasmethod";
    }

    public String getClassJavadoc() {
        return "Uses the alias sampling method to encode and sample from discrete probabilities,\neven over larger sets of data. This form requires a unit interval sample value\nbetween 0.0 and 1.0. Assuming the maximal amount of memory is used for distinct\noutcomes N, a memory buffer of N*16 bytes is required for this implementation,\nrequiring 32MB of memory for 1M entries.\n\nThis sampler should be shared between threads, and will be by default, in order\nto avoid many instances of a 32MB buffer on heap.\n";
    }

    public String getInType() {
        return "double";
    }

    public String getOutType() {
        return "T";
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("AliasElementSampler", "Setup an alias table for T type objects.\n@param biases An array of the unfair die model values\n@param elements An array of elements of type T, two values per bias value. index 2n is bot, index 2n+1 is top.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("biases", "double[]");
                        this.put("elements", "T[]");
                    }
                }, (List)new ArrayList<List<String>>(){}));
                this.add(new DocForFuncCtor("AliasElementSampler", "", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("elements", "java.util.Collection<T>");
                        this.put("weightFunction", "java.util.function.Function<T,java.lang.Double>");
                    }
                }, (List)new ArrayList<List<String>>(){}));
                this.add(new DocForFuncCtor("AliasElementSampler", "", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("events", "java.util.List<io.virtdata.stathelpers.ElemProbD<T>>");
                    }
                }, (List)new ArrayList<List<String>>(){}));
            }
        };
    }
}

