// This file is auto-generated.
package io.virtdata.basicsmappers.from_long.to_uuid;

import io.virtdata.annotations.Category;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ToUUIDAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "ToUUID";
  }

  public String getPackageName() {
    return "io.virtdata.basicsmappers.from_long.to_uuid";
  }

  public String getClassJavadoc() {
    return "This function creates a non-random UUID in the type 4 version (Random).\n"
            + "It always puts the same value in the MSB position of the UUID format.\n"
            + "The input value is put in the LSB position.\n"
            + "<pre>\n"
            + "xxxxxxxx-xxxx-Mxxx-Nxxx-xxxxxxxxxxxx\n"
            + "mmmmmmmm-mmmm-Mmmm-Llll-llllllllllll\n"
            + "              4    3\n"
            + "</pre>\n"
            + "As shown above, the LSB position does not have the complication of having\n"
            + "a version identifier (position M) dividing the dynamic range of the data type.\n"
            + "For this reason, only the LSB side is used for this mapper, which allows\n"
            + "an effective range of Long.MAX_VALUE/8, given the loss of 3 digits of precision.\n"
            + "\n"
            + "This function is suitable for deterministic testing of scenarios which depend\n"
            + "on type 4 UUIDs, but without the mandated randomness that makes testing difficult.\n"
            + "Just be aware that the MSB will always contain value 0x0123456789ABCDEFL unless you\n"
            + "specify a different long value to pre-fill it with.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.util.UUID";
  }

  public Category[] getCategories() {
    return new Category[] {  };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("ToUUID", "", 
            new LinkedHashMap<String, String>() {{
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("ToUUID", "", 
            new LinkedHashMap<String, String>() {{
              put("msbs","long");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
