/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.basicsmappers.from_long.to_long.Hash;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class AlphaNumericString
implements LongFunction<String> {
    private static final String AVAILABLE_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final ThreadLocal<StringBuilder> threadStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
    private final Hash hash = new Hash();
    private final int length;

    public AlphaNumericString(int length) {
        if (length < 0) {
            throw new RuntimeException("AlphaNumericString must have length >= 0");
        }
        this.length = length;
    }

    @Override
    public String apply(long operand) {
        long hashValue = operand;
        StringBuilder sb = this.threadStringBuilder.get();
        sb.setLength(0);
        for (int i = 0; i < this.length; ++i) {
            hashValue = this.hash.applyAsLong(hashValue);
            int randomPos = (int)(hashValue % (long)AVAILABLE_CHARS.length());
            sb.append(AVAILABLE_CHARS.charAt(randomPos));
        }
        return sb.toString();
    }

    public String toString() {
        return "AlphaNumericString(length=" + this.length + ")";
    }
}

