/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers;

import java.util.ArrayList;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeFormats {
    public static final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZ").withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withChronology((Chronology)GregorianChronology.getInstance()), ISODateTimeFormat.basicDateTime().withChronology((Chronology)GregorianChronology.getInstance()), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), ISODateTimeFormat.date().withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyyMMdd").withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyyMM").withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyy").withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance())};
    public static DateTime gregorianCalendarStart = new DateTime(1582, 10, 15, 0, 0, DateTimeZone.UTC);

    /*
     * WARNING - void declaration
     */
    public static DateTime parseEpochTimeToDateTime(String timeString) {
        void var4_6;
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        DateTimeFormatter[] dateTimeFormatterArray = formatters;
        int n = dateTimeFormatterArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            DateTimeFormatter dtf = dateTimeFormatterArray[var4_6];
            try {
                DateTime dateTime = dtf.withZoneUTC().parseDateTime(timeString);
                return dateTime;
            }
            catch (Exception e) {
                exceptions.add(new RuntimeException("as '" + dtf.print((ReadableInstant)DateTime.now()) + "': " + e.getMessage()));
                ++var4_6;
            }
        }
        String message = "";
        for (Exception exception : exceptions) {
            message = message + exception.getMessage() + "\n";
        }
        throw new RuntimeException("Unable to parse [" + timeString + "] with any of the parsers. exceptions:" + message + ", examples of valid formats are included above");
    }

    public static long parseEpochTimeToGregorianMillis(String timeString) {
        DateTime dateTime = DateTimeFormats.parseEpochTimeToDateTime(timeString);
        return new Duration((ReadableInstant)gregorianCalendarStart, (ReadableInstant)dateTime).getMillis();
    }

    public static long parseEpochTimeToTimeUUIDTicks(String timeString) {
        long l = DateTimeFormats.parseEpochTimeToGregorianMillis(timeString);
        return l * 10000L;
    }
}

