package io.virtdata.basicsmappers.from_long.to_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.threadstate.ThreadLocalState;

import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
@Categories({Category.state})
public class Save implements LongUnaryOperator {

    private final String name;
    private final LongFunction<String> nameGen;

    @Example({"Save('foo')","save the current long value to the name 'foo' in this thread"})
    public Save(String name) {
        this.name = name;
        this.nameGen=null;
    }

    @Example({"Save(NumberNameToString())","save the current long value to the name generated by the function given."})
    public Save(LongFunction<String> nameFunc) {
        this.name=null;
        this.nameGen=nameFunc;
    }

    @Override
    public long applyAsLong(long operand) {
        String varname = (nameGen!=null) ? nameGen.apply(operand) : name;
        ThreadLocalState.tl_ObjectMap.get().put(varname,operand);
        return operand;
    }
}
