/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.threadstate.ThreadLocalState;
import java.util.HashMap;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.state})
public class Load
implements Function<Object, Object> {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"Load('foo')", "for the current thread, load an Object value from the named variable"})
    public Load(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"Load('foo')", "for the current thread, load an Object value from the named variable, where the variable name is returned by the provided function"})
    public Load(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public Object apply(Object o) {
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(o)) : this.name;
        HashMap<String, Object> map = ThreadLocalState.tl_ObjectMap.get();
        return map.get(varname);
    }
}

