/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.threadstate.ThreadLocalState;
import java.util.HashMap;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.state})
public class Swap
implements Function<Object, Object> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final Object defaultValue;

    @Example(value={"Swap('foo')", "for the current thread, swap the input value with the named variable and returned the named variable"})
    public Swap(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = null;
    }

    @Example(value={"Swap('foo')", "for the current thread, swap the input value with the named variable and returned the named variable"})
    public Swap(String name, Object defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"Swap(NumberNameToString())", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function"})
    public Swap(Function<Object, Object> nameFunc) {
        this.nameFunc = nameFunc;
        this.name = null;
        this.defaultValue = null;
    }

    @Example(value={"Swap(NumberNameToString())", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function"})
    public Swap(Function<Object, Object> nameFunc, Object defaultValue) {
        this.nameFunc = nameFunc;
        this.name = null;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object apply(Object o) {
        HashMap<String, Object> map = ThreadLocalState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(o)) : this.name;
        Object output = map.get(varname);
        map.put(this.name, o);
        return output != null ? output : this.defaultValue;
    }
}

