/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.unary_int;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class Clamp
implements IntUnaryOperator {
    private final int min;
    private final int max;

    @Example(value={"Clamp(1,100)", "clamp the output values in the range [1,100], inclusive"})
    public Clamp(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public int applyAsInt(int operand) {
        return Integer.min(this.max, Integer.max(this.min, operand));
    }
}

