/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_time_types;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.basicsmappers.DateTimeFormats;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class StartingEpochMillis
implements LongUnaryOperator {
    private final DateTime startingTime;
    private final long startingUnixEpochMillis;
    private final long headroom;

    @Example(value={"StartingEpochMillis('2017-01-01 23:59:59')", "add the millisecond epoch time of 2017-01-01 23:59:59 to all input values"})
    public StartingEpochMillis(String baseTimeSpec) {
        this.startingTime = DateTimeFormats.parseEpochTimeToDateTime(baseTimeSpec);
        this.startingUnixEpochMillis = this.startingTime.getMillis();
        this.headroom = Long.MAX_VALUE - this.startingUnixEpochMillis;
    }

    @Override
    public long applyAsLong(long value) {
        return this.startingUnixEpochMillis + value % this.headroom;
    }
}

